/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.demos.action;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.cluster.verification.InvalidPathException;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.VerificationTask;
import oracle.install.commons.base.interview.common.action.AbstractPrereqAction;
import oracle.install.commons.base.interview.common.validator.PrereqValidator;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.Route;
import oracle.install.commons.flow.annotation.UIRef;
import oracle.install.commons.flow.validation.annotation.ValidatorRef;
import oracle.install.ivw.common.bean.AutoUpdatesInstallSettings;
import oracle.install.library.util.PlatformInfo;
import oracle.install.library.util.cvu.CVUHelper;

@UIRef(value="PrereqUI")
@ValidatorRef(value=PrereqValidator.class)
public class PrereqAction
extends AbstractPrereqAction {
    private static final Logger logger = Logger.getLogger(PrereqAction.class.getName());

    public List<VerificationTask> getProductVerificationTasks(FlowContext flowContext) throws VerificationException {
        List tasks = null;
        AutoUpdatesInstallSettings autoBean = (AutoUpdatesInstallSettings)flowContext.getBean(AutoUpdatesInstallSettings.class);
        CVUHelper cvu = CVUHelper.getInstance();
        this.setCVUVariables(flowContext, cvu);
        String defaultFile = CVUHelper.getPrereqXML((boolean)autoBean.isApplyUpdates(), (String)autoBean.getPatchDownloadLocation());
        try {
            cvu.setPreReqXmlFile(defaultFile);
            logger.log(Level.INFO, "CVU PREREQ SET TO: " + defaultFile);
        }
        catch (InvalidPathException e) {
            logger.log(Level.WARNING, "Exception occurred while setting the custom prereq xml file");
        }
        tasks = cvu.getPreReqTasksForSIDBInst();
        return tasks;
    }

    public void setCVUVariables(FlowContext flowContext, CVUHelper cvu) throws VerificationException {
        PlatformInfo platformInfo = PlatformInfo.getInstance();
        String temp = null;
        String cv_destLoc = null;
        temp = System.getenv("TEMP") != null ? System.getenv("TEMP") : "/tmp";
        cvu.setVariableValue("TEMP_AREA", temp);
        cv_destLoc = System.getenv("CV_DESTLOC");
        if (cv_destLoc != null) {
            cvu.setVariableValue("CV_DESTLOC", cv_destLoc);
        }
        cvu.setVariableValue("CLIENT_INSTALL", "true");
    }

    public final Route transition(FlowContext flowContext) {
        return Route.SUCCESS;
    }
}

